/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.services.PdfBuilderService;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.IOException;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PdfBuilderServiceServiceImpl
implements PdfBuilderService {
    final Logger log = LoggerFactory.getLogger(PdfBuilderServiceServiceImpl.class);
    @Value(value="${cbm.htmlFormLocation}")
    private final String htmlFormLocation;
    @Value(value="${cbm.pdfFiles}")
    private final String pdfFilePath;

    public PdfBuilderServiceServiceImpl(@Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public void generatePdf(String pdfSaveLocation, String pdfFileName, Document doc) throws IOException {
        this.log.info(pdfSaveLocation + pdfFileName);
        try {
            this.log.info("Starting the pdf process");
            PdfWriter writer = new PdfWriter(pdfSaveLocation + pdfFileName);
            PdfDocument document = new PdfDocument(writer);
            document.setTagged();
            this.log.info("Conversion process starting");
            HtmlConverter.convertToPdf((String)doc.toString(), (PdfWriter)document.getWriter());
        }
        catch (IOException ioExc) {
            this.log.info(ioExc.getMessage());
        }
    }
}

