/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.BonusDate;
import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.BonusRepository;
import com.cbmportal.portal.services.BonusService;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class BonusServiceImpl
implements BonusService {
    final Logger log = LoggerFactory.getLogger(BonusServiceImpl.class);
    private final BonusRepository bonusRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public BonusServiceImpl(BonusRepository bonusRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.bonusRepository = bonusRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processBonus(Bonus bonus, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File bonusHtml = new File(this.htmlFormLocation + "bonus.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        StringBuilder bonusInfo = new StringBuilder();
        String fullEmployeeName = bonus.getEmployee().getEmployeeFirst() + " " + bonus.getEmployee().getEmployeeLast();
        String pdfFileName = "Bonus-" + fullEmployeeName + "-" + bonus.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "bonus/" + bonus.getEmployee().getEmployeeNumber() + "/";
        this.bonusInject(bonus.getBonuses(), dateFormatter, bonusInfo);
        Document doc = Jsoup.parse((File)bonusHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("bonusInfo").html(bonusInfo.toString());
        doc.getElementsByClass("comments").html(bonus.getComments());
        doc.getElementsByClass("employeeNum").html(bonus.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dmSig").html("<img src=" + bonus.getSig() + " alt=\" This is signature\" />");
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Payroll.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, bonus.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                Bonus savedBonus = (Bonus)this.bonusRepository.save(bonus);
                if (savedBonus.getId() != null) {
                    formResponse.setFormName("Bonus Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/payroll/bonusSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Bonus Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private void bonusInject(List<BonusDate> bonuses, DateTimeFormatter dateTimeFormatter, StringBuilder bonusInfo) {
        for (BonusDate bonusItem : bonuses) {
            bonusInfo.append("<div class=\"date-info\">").append(dateTimeFormatter.format(bonusItem.getDate())).append("</div>");
            bonusInfo.append("<div class=\"location-info\">").append(bonusItem.getStore().getStoreNum()).append(" ").append(bonusItem.getStore().getName()).append("</div>");
            bonusInfo.append("<div class=\"amount-info\">").append(bonusItem.getBonus()).append("</div>");
        }
    }
}

