/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Department;
import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Pto {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pto_id_seq")
    @SequenceGenerator(name="pto_id_seq", sequenceName="pto_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private LocalDate absenceFrom;
    @JsonProperty
    private LocalDate absenceTo;
    @JsonProperty
    private Double hours;
    @JsonProperty
    private Department department;
    @JsonProperty
    private String comments;
    @JsonProperty
    private String sig;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pto pto = (Pto)o;
        return Objects.equals(this.id, pto.id) && Objects.equals(this.absenceFrom, pto.absenceFrom) && Objects.equals(this.absenceTo, pto.absenceTo) && Objects.equals(this.hours, pto.hours) && this.department == pto.department && Objects.equals(this.comments, pto.comments) && Objects.equals(this.sig, pto.sig) && Objects.equals(this.employee, pto.employee) && Objects.equals(this.portalUser, pto.portalUser) && Objects.equals(this.apiError, pto.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", Pto.class.getSimpleName() + "[", "]").add("id=" + this.id).add("absenceFrom=" + this.absenceFrom).add("absenceTo=" + this.absenceTo).add("hours=" + this.hours).add("department=" + this.department).add("comments='" + this.comments + "'").add("sig='" + this.sig + "'").add("employee=" + this.employee).add("portalUser=" + this.portalUser).add("apiError=" + this.apiError).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.absenceFrom, this.absenceTo, this.hours, this.department, this.comments, this.sig, this.employee, this.portalUser, this.apiError});
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setAbsenceFrom(LocalDate absenceFrom) {
        this.absenceFrom = absenceFrom;
    }

    @JsonProperty
    public void setAbsenceTo(LocalDate absenceTo) {
        this.absenceTo = absenceTo;
    }

    @JsonProperty
    public void setHours(Double hours) {
        this.hours = hours;
    }

    @JsonProperty
    public void setDepartment(Department department) {
        this.department = department;
    }

    @JsonProperty
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    public void setSig(String sig) {
        this.sig = sig;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public LocalDate getAbsenceFrom() {
        return this.absenceFrom;
    }

    public LocalDate getAbsenceTo() {
        return this.absenceTo;
    }

    public Double getHours() {
        return this.hours;
    }

    public Department getDepartment() {
        return this.department;
    }

    public String getComments() {
        return this.comments;
    }

    public String getSig() {
        return this.sig;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

