/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.HotelReason;
import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;

@Entity
public class Hotel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="hotel_id_seq")
    @SequenceGenerator(name="hotel_id_seq", sequenceName="hotel_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser;
    @JsonProperty
    @OneToOne
    private Store store;
    @JsonProperty
    private LocalDate checkIn;
    @JsonProperty
    private LocalDate checkOut;
    @JsonProperty
    private Integer numOfRooms;
    @JsonProperty
    private Integer numOfBeds;
    @JsonProperty
    @OneToOne
    private PS ps1;
    @JsonProperty
    @OneToOne
    private PS ps2;
    @JsonProperty
    private String newPS;
    @JsonProperty
    private HotelReason hotelReason;
    @JsonProperty
    private String workTicket;
    @JsonProperty
    private String comments;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public Hotel() {
    }

    public Hotel(PortalUser portalUser, Store store, LocalDate checkIn, LocalDate checkOut, Integer numOfRooms, Integer numOfBeds, PS ps1, PS ps2, String newPS, HotelReason hotelReason, String workTicket, String comments, ApiError apiError) {
        this.portalUser = portalUser;
        this.store = store;
        this.checkIn = checkIn;
        this.checkOut = checkOut;
        this.numOfRooms = numOfRooms;
        this.numOfBeds = numOfBeds;
        this.ps1 = ps1;
        this.ps2 = ps2;
        this.newPS = newPS;
        this.hotelReason = hotelReason;
        this.workTicket = workTicket;
        this.comments = comments;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hotel hotel = (Hotel)o;
        return Objects.equals(this.id, hotel.id) && Objects.equals(this.portalUser, hotel.portalUser) && Objects.equals(this.store, hotel.store) && Objects.equals(this.checkIn, hotel.checkIn) && Objects.equals(this.checkOut, hotel.checkOut) && Objects.equals(this.numOfRooms, hotel.numOfRooms) && Objects.equals(this.numOfBeds, hotel.numOfBeds) && Objects.equals(this.ps1, hotel.ps1) && Objects.equals(this.ps2, hotel.ps2) && Objects.equals(this.newPS, hotel.newPS) && this.hotelReason == hotel.hotelReason && Objects.equals(this.workTicket, hotel.workTicket) && Objects.equals(this.comments, hotel.comments) && Objects.equals(this.apiError, hotel.apiError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.portalUser, this.store, this.checkIn, this.checkOut, this.numOfRooms, this.numOfBeds, this.ps1, this.ps2, this.newPS, this.hotelReason, this.workTicket, this.comments, this.apiError});
    }

    public String toString() {
        return new StringJoiner(", ", Hotel.class.getSimpleName() + "[", "]").add("id=" + this.id).add("portalUser=" + this.portalUser).add("store=" + this.store).add("checkIn=" + this.checkIn).add("checkOut=" + this.checkOut).add("numOfRooms=" + this.numOfRooms).add("numOfBeds=" + this.numOfBeds).add("ps1=" + this.ps1).add("ps2=" + this.ps2).add("newPS='" + this.newPS + "'").add("hotelReason=" + this.hotelReason).add("workTicket='" + this.workTicket + "'").add("comments='" + this.comments + "'").add("apiError=" + this.apiError).toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    public void setCheckIn(LocalDate checkIn) {
        this.checkIn = checkIn;
    }

    @JsonProperty
    public void setCheckOut(LocalDate checkOut) {
        this.checkOut = checkOut;
    }

    @JsonProperty
    public void setNumOfRooms(Integer numOfRooms) {
        this.numOfRooms = numOfRooms;
    }

    @JsonProperty
    public void setNumOfBeds(Integer numOfBeds) {
        this.numOfBeds = numOfBeds;
    }

    @JsonProperty
    public void setPs1(PS ps1) {
        this.ps1 = ps1;
    }

    @JsonProperty
    public void setPs2(PS ps2) {
        this.ps2 = ps2;
    }

    @JsonProperty
    public void setNewPS(String newPS) {
        this.newPS = newPS;
    }

    @JsonProperty
    public void setHotelReason(HotelReason hotelReason) {
        this.hotelReason = hotelReason;
    }

    @JsonProperty
    public void setWorkTicket(String workTicket) {
        this.workTicket = workTicket;
    }

    @JsonProperty
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public Store getStore() {
        return this.store;
    }

    public LocalDate getCheckIn() {
        return this.checkIn;
    }

    public LocalDate getCheckOut() {
        return this.checkOut;
    }

    public Integer getNumOfRooms() {
        return this.numOfRooms;
    }

    public Integer getNumOfBeds() {
        return this.numOfBeds;
    }

    public PS getPs1() {
        return this.ps1;
    }

    public PS getPs2() {
        return this.ps2;
    }

    public String getNewPS() {
        return this.newPS;
    }

    public HotelReason getHotelReason() {
        return this.hotelReason;
    }

    public String getWorkTicket() {
        return this.workTicket;
    }

    public String getComments() {
        return this.comments;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

