/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.BonusDate;
import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Bonus {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bonus_id_seq")
    @SequenceGenerator(name="bonus_id_seq", sequenceName="bonus_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<BonusDate> bonuses;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser;
    @JsonProperty
    private String comments;
    @JsonProperty
    private String sig;
    @Transient
    @JsonProperty
    private ApiError apiError;

    public Bonus() {
    }

    public Bonus(List<BonusDate> bonuses, Employee employee, PortalUser portalUser, String comments, String sig, ApiError apiError) {
        this.bonuses = bonuses;
        this.employee = employee;
        this.portalUser = portalUser;
        this.comments = comments;
        this.sig = sig;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bonus bonus = (Bonus)o;
        return Objects.equals(this.id, bonus.id) && Objects.equals(this.bonuses, bonus.bonuses) && Objects.equals(this.employee, bonus.employee) && Objects.equals(this.portalUser, bonus.portalUser) && Objects.equals(this.comments, bonus.comments) && Objects.equals(this.sig, bonus.sig) && Objects.equals(this.apiError, bonus.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", Bonus.class.getSimpleName() + "[", "]").add("id=" + this.id).add("bonuses=" + this.bonuses).add("employee=" + this.employee).add("portalUser=" + this.portalUser).add("comments='" + this.comments + "'").add("sig='" + this.sig + "'").add("apiError=" + this.apiError).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bonuses, this.employee, this.portalUser, this.comments, this.sig, this.apiError);
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setBonuses(List<BonusDate> bonuses) {
        this.bonuses = bonuses;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    public void setSig(String sig) {
        this.sig = sig;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public List<BonusDate> getBonuses() {
        return this.bonuses;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public String getComments() {
        return this.comments;
    }

    public String getSig() {
        return this.sig;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

