/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.BackPayDate;
import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
public class BackPay {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="backPay_id_seq")
    @SequenceGenerator(name="backPay_id_seq", sequenceName="back_pay_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser = null;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    private Store store = null;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<BackPayDate> backPayDates = null;
    @JsonProperty
    private String payMissed = null;
    @Column(length=2000)
    @JdbcTypeCode(value=12)
    @JsonProperty
    private String sig = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackPay backPay = (BackPay)o;
        return Objects.equals(this.id, backPay.id) && Objects.equals(this.portalUser, backPay.portalUser) && Objects.equals(this.employee, backPay.employee) && Objects.equals(this.store, backPay.store) && Objects.equals(this.backPayDates, backPay.backPayDates) && Objects.equals(this.payMissed, backPay.payMissed) && Objects.equals(this.sig, backPay.sig) && Objects.equals(this.apiError, backPay.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.portalUser, this.employee, this.store, this.backPayDates, this.payMissed, this.sig, this.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", BackPay.class.getSimpleName() + "[", "]").add("id=" + this.id).add("portalUser=" + this.portalUser).add("employee=" + this.employee).add("store=" + this.store).add("backPayDates=" + this.backPayDates).add("payMissed='" + this.payMissed + "'").add("sig='" + this.sig + "'").add("apiError=" + this.apiError).toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    public void setBackPayDates(List<BackPayDate> backPayDates) {
        this.backPayDates = backPayDates;
    }

    @JsonProperty
    public void setPayMissed(String payMissed) {
        this.payMissed = payMissed;
    }

    @JsonProperty
    public void setSig(String sig) {
        this.sig = sig;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public Store getStore() {
        return this.store;
    }

    public List<BackPayDate> getBackPayDates() {
        return this.backPayDates;
    }

    public String getPayMissed() {
        return this.payMissed;
    }

    public String getSig() {
        return this.sig;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

