/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.TargetItem;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.VO.TargetItemWrapper;
import com.cbmportal.portal.services.PSService;
import com.cbmportal.portal.services.TargetItemService;
import com.cbmportal.portal.services.TargetOrderService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jsoup.helper.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerErrorException;

@RestController
@RequestMapping(value={"/api/v1/ops"})
public class OperationsSubmissions {
    final Logger log = LoggerFactory.getLogger(OperationsSubmissions.class);
    private final TargetOrderService targetOrderService;
    private final PSService psService;
    private final TargetItemService targetItemService;

    public OperationsSubmissions(TargetOrderService targetOrderService, PSService psService, TargetItemService targetItemService) {
        this.targetOrderService = targetOrderService;
        this.psService = psService;
        this.targetItemService = targetItemService;
    }

    @PostMapping(value={"/targetOrderSubmit"})
    ResponseEntity<FormSubmissionResponse> targetOrderSubmit(@RequestBody TargetOrder targetOrder, HttpServletResponse response) throws IOException {
        this.log.info(targetOrder.toString());
        if (!targetOrder.getTargetOrderItems().isEmpty() && targetOrder.getStore() != null && targetOrder.getPortalUser() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.targetOrderService.processTargetOrder(targetOrder, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Target Order Form", false, new ApiError("submitTargetOrder", "Please fill in every field that has an * next to it.")));
    }

    @GetMapping(value={"/getPSByPortalUserId/{portalUserId}"})
    public ResponseEntity<List<PS>> getPSByPortalUserId(@PathVariable long portalUserId) {
        List<PS> returnedPsList = this.psService.findPSByPortalUser(portalUserId);
        return ResponseEntity.ok().body(returnedPsList);
    }

    @GetMapping(value={"/getPS"})
    ResponseEntity<List<PS>> getPS(HttpServletResponse response) {
        ArrayList psList = new ArrayList();
        this.psService.getPS().iterator().forEachRemaining(psList::add);
        return ResponseEntity.status((int)response.getStatus()).body(psList);
    }

    @PostMapping(value={"/createTargetItem"})
    ResponseEntity<TargetItem> createTargetOrderItem(@RequestBody TargetItem targetItem, HttpServletResponse response, HttpServletRequest request) {
        TargetItem savedTargetItem = new TargetItem();
        try {
            savedTargetItem = this.targetItemService.targetItemCreation(targetItem);
            if (savedTargetItem == null) {
                return ResponseEntity.ok().body(null);
            }
            return ResponseEntity.ok().body((Object)savedTargetItem);
        }
        catch (NullPointerException | ValidationException exc) {
            if (savedTargetItem != null) {
                savedTargetItem.setApiError(new ApiError(request.getRequestURI(), exc.getMessage()));
            }
            return ResponseEntity.status((int)response.getStatus()).body((Object)savedTargetItem);
        }
    }

    @GetMapping(value={"/getTargetItems"})
    ResponseEntity<TargetItemWrapper> getTargetItems(HttpServletRequest request) {
        TargetItemWrapper targetItemWrapper = new TargetItemWrapper();
        try {
            List<TargetItem> targetItems = this.targetItemService.getTargetItems();
            targetItemWrapper.setTargetItems(targetItems);
            if (targetItems.isEmpty()) {
                targetItemWrapper.setApiError(new ApiError(request.getRequestURI(), "No items were found."));
            }
            return ResponseEntity.ok().body((Object)targetItemWrapper);
        }
        catch (ServerErrorException sExc) {
            targetItemWrapper.setApiError(new ApiError(request.getRequestURI(), sExc.getMessage()));
            return ResponseEntity.status((HttpStatusCode)sExc.getStatusCode()).body((Object)targetItemWrapper);
        }
    }
}

