/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.LoginResponseVO;
import com.cbmportal.portal.services.AuthenticationService;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/auth"})
public class Auth {
    private final AuthenticationService authenticationService;

    public Auth(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value={"/register"})
    public PortalUser registerUser(@RequestBody PortalUser portalUser) {
        return this.authenticationService.registerUser(portalUser);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<LoginResponseVO> loginUser(@RequestBody PortalUser portalUser, HttpServletResponse response) {
        if (portalUser.getUsername() != null && !portalUser.getUsername().isEmpty() && portalUser.getPassword() != null && !portalUser.getPassword().isEmpty()) {
            LoginResponseVO loginResponse = this.authenticationService.loginUser(portalUser.getUsername(), portalUser.getPassword(), response);
            if (response.getStatus() == 200) {
                return ResponseEntity.ok().body((Object)loginResponse);
            }
            return ResponseEntity.status((int)response.getStatus()).body((Object)loginResponse);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new LoginResponseVO("", false, new ApiError("loginUser", "Please fill in every field.")));
    }

    @GetMapping(value={"/validateToken"})
    public ResponseEntity<LoginResponseVO> validateToken(@RequestParam String token) {
        return ResponseEntity.ok().body((Object)this.authenticationService.validateJwt(token));
    }
}

