/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.PerDiemRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.PerDiemService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PerDiemServiceImpl
extends AbstractFormProcessingService<PerDiem>
implements PerDiemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PerDiemServiceImpl.class);
    private final HtmlFragmentBuilder htmlBuilder;

    public PerDiemServiceImpl(PerDiemRepository perDiemRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, HtmlFragmentBuilder htmlBuilder) {
        super(pdfBuilderService, emailService, (JpaRepository)perDiemRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.htmlBuilder = htmlBuilder;
    }

    public FormSubmissionResponse processPerDiem(PerDiem perDiem, HttpServletResponse response) {
        return this.processForm((Object)perDiem);
    }

    protected void validateFormData(PerDiem perDiem) {
        if (perDiem == null) {
            throw new FormProcessingException("Per diem data cannot be null");
        }
        if (perDiem.getEmployee() == null || perDiem.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (perDiem.getStore() == null) {
            throw new FormProcessingException("Store information is required");
        }
        if (perDiem.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
    }

    protected FormContext buildFormContext(PerDiem perDiem) {
        String fullEmployeeName = perDiem.getEmployee().getEmployeeFirst() + " " + perDiem.getEmployee().getEmployeeLast();
        String empNum = perDiem.getEmployee().getEmployeeNumber().toString();
        String financeEmail = this.getDepartmentEmail("Finance", "Per Diem");
        return FormContext.builder().employee(perDiem.getEmployee()).pdfFileName("PerDiem-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"perdiem", empNum})).recipients(List.of(financeEmail, perDiem.getPortalUser().getEmail())).emailSubject("Per Diem Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum, perDiem.getStore())).storeName(perDiem.getStore().getName()).storeNumber(perDiem.getStore().getStoreNum()).portalUserName(perDiem.getPortalUser().getUserFirst() + " " + perDiem.getPortalUser().getUserLast()).formType("PER_DIEM").build();
    }

    protected Document generateHtmlDocument(FormContext context, PerDiem perDiem) throws IOException {
        File perDiemHtml = new File(this.htmlFormLocation + "perdiem.html");
        Document doc = Jsoup.parse((File)perDiemHtml, (String)"UTF-8", (String)"");
        long numDays = 0L;
        if (perDiem.getFirstHotelNight() != null && perDiem.getLastHotelNight() != null) {
            numDays = ChronoUnit.DAYS.between(perDiem.getFirstHotelNight(), perDiem.getLastHotelNight()) + 1L;
        }
        StringBuilder mileageInfo = new StringBuilder();
        if (perDiem.getMileageDates() != null) {
            for (MileageDate mileageDate : perDiem.getMileageDates()) {
                String startLocation = mileageDate.getLocation1().getStoreNum() + " " + mileageDate.getLocation1().getName();
                String endLocation = mileageDate.getLocation2().getStoreNum() + " " + mileageDate.getLocation2().getName();
                mileageInfo.append(this.htmlBuilder.perDiemMileage(mileageDate.getDate(), startLocation, endLocation, mileageDate.getRt_ow().toString(), this.dateFormatter));
            }
        }
        doc.getElementsByClass("employeeNum").html(String.valueOf(context.getEmployee().getEmployeeNumber()));
        doc.getElementsByClass("employeeName").html(context.getEmployee().getEmployeeFirst() + " " + context.getEmployee().getEmployeeLast());
        doc.getElementsByClass("storeName").html(context.getStoreNumber() + " " + context.getStoreName());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("location").html(perDiem.getStore().getStoreNum() + " - " + perDiem.getStore().getName());
        doc.getElementsByClass("city").html(perDiem.getStore().getCity());
        doc.getElementsByClass("state").html(perDiem.getStore().getState());
        doc.getElementsByClass("mileageDates").html(mileageInfo.toString());
        if (perDiem.getFirstHotelNight() != null) {
            doc.getElementsByClass("firstHotelNight").html(this.dateFormatter.format(perDiem.getFirstHotelNight()));
        }
        if (perDiem.getLastHotelNight() != null) {
            doc.getElementsByClass("lastHotelNight").html(this.dateFormatter.format(perDiem.getLastHotelNight()));
        }
        if (perDiem.getArrivalDate() != null) {
            doc.getElementsByClass("arrivalDate").html(this.dateFormatter.format(perDiem.getArrivalDate()));
        }
        if (perDiem.getDepartureDate() != null) {
            doc.getElementsByClass("departureDate").html(this.dateFormatter.format(perDiem.getDepartureDate()));
        }
        doc.getElementsByClass("numDays").html(String.valueOf(numDays));
        doc.getElementsByClass("mileageInfo").html(mileageInfo.toString());
        doc.getElementsByClass("reasonPayMissed").html(this.htmlBuilder.valueOrDefault(perDiem.getReasonPayMissed(), ""));
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "Per Diem Form";
    }

    protected Long getEntityId(PerDiem entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(PerDiem perDiem) {
        perDiem.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber, Store store) {
        return this.htmlBuilder.emailBodyWithStore("Per Diem Form", employeeName, employeeNumber, store.getStoreNum() + " " + store.getName());
    }
}

