/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.VO.DistrictSafeVO;
import com.cbmportal.portal.repositories.DistrictRepository;
import com.cbmportal.portal.services.DistrictService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DistrictServiceImpl
implements DistrictService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistrictServiceImpl.class);
    private final DistrictRepository districtRepository;

    public DistrictServiceImpl(DistrictRepository districtRepository) {
        this.districtRepository = districtRepository;
    }

    public List<DistrictSafeVO> getAllDistrictsSafe() {
        log.debug("Fetching all districts");
        ArrayList<DistrictSafeVO> safeList = new ArrayList<DistrictSafeVO>();
        for (District district : this.districtRepository.findAll()) {
            DistrictSafeVO vo = new DistrictSafeVO(district.getId(), district.getDistrictName());
            if (district.getStore() != null) {
                vo.setStoreId(district.getStore().getId());
                vo.setStoreName(district.getStore().getName());
                vo.setStoreNum(district.getStore().getStoreNum());
                vo.setStoreCity(district.getStore().getCity());
                vo.setStoreState(district.getStore().getState());
            }
            safeList.add(vo);
        }
        log.debug("Retrieved {} districts", (Object)safeList.size());
        return safeList;
    }
}

