/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.DatabaseOperationException;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.jpa.repository.JpaRepository;

public abstract class AbstractFormProcessingService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractFormProcessingService.class);
    protected final PdfBuilderService pdfBuilderService;
    protected final MicrosoftGraphEmailService emailService;
    protected final JpaRepository<T, Long> repository;
    protected final String htmlFormLocation;
    protected final CustomProperties customProperties;
    protected final PdfStorageHelper pdfStorageHelper;
    protected final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-yyyy");

    protected AbstractFormProcessingService(PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, JpaRepository<T, Long> repository, String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        this.pdfBuilderService = pdfBuilderService;
        this.emailService = emailService;
        this.repository = repository;
        this.htmlFormLocation = htmlFormLocation;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
    }

    public final FormSubmissionResponse processForm(T formData) {
        log.info("Starting {} processing", (Object)this.getFormName());
        try {
            this.validateFormData(formData);
            log.debug("{} validation successful", (Object)this.getFormName());
            FormContext context = this.buildFormContext(formData);
            log.debug("Form context built for {}", (Object)this.getFormName());
            Document htmlDoc = this.generateHtmlDocument(context, formData);
            log.debug("HTML document generated for {}", (Object)this.getFormName());
            File pdfFile = this.createPdfFile(context, htmlDoc);
            log.info("PDF created successfully: {}", (Object)pdfFile.getName());
            this.sendEmailNotification(context, pdfFile);
            log.info("Email notification sent for {}", (Object)this.getFormName());
            this.setSubmittedDate(formData);
            log.debug("Submitted date set for {}", (Object)this.getFormName());
            Object savedEntity = this.repository.save(formData);
            if (this.getEntityId(savedEntity) == null) {
                throw new DatabaseOperationException("Failed to save " + this.getFormName());
            }
            log.info("{} saved to database with ID: {}", (Object)this.getFormName(), (Object)this.getEntityId(savedEntity));
            return this.buildSuccessResponse();
        }
        catch (IOException e) {
            log.error("IO error processing {} form", (Object)this.getFormName(), (Object)e);
            throw new FormProcessingException("Error generating " + this.getFormName(), (Throwable)e);
        }
        catch (DataAccessException e) {
            log.error("Database error processing {} form", (Object)this.getFormName(), (Object)e);
            throw new DatabaseOperationException("Failed to save " + this.getFormName(), (Throwable)e);
        }
        catch (DatabaseOperationException | FormProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error processing {} form", (Object)this.getFormName(), (Object)e);
            throw new FormProcessingException("Unexpected error in " + this.getFormName(), (Throwable)e);
        }
    }

    protected File createPdfFile(FormContext context, Document htmlDoc) throws IOException {
        String pdfSaveLocation = context.getPdfSaveLocation();
        String pdfFileName = context.getPdfFileName();
        File directory = new File(pdfSaveLocation);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new FormProcessingException("Failed to create directory: " + directory.getPath());
        }
        File pdfFile = new File(pdfSaveLocation + pdfFileName);
        this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, htmlDoc);
        if (!pdfFile.exists() || pdfFile.isDirectory()) {
            throw new FormProcessingException("Failed to generate PDF file: " + pdfFileName);
        }
        log.debug("PDF file created successfully: {}", (Object)pdfFileName);
        return pdfFile;
    }

    protected void sendEmailNotification(FormContext context, File pdfFile) {
        this.emailService.sendEmail(context.getRecipients(), context.getEmailSubject(), context.getEmailBody(), pdfFile);
        log.debug("Email sent successfully for {}", (Object)this.getFormName());
    }

    protected FormSubmissionResponse buildSuccessResponse() {
        FormSubmissionResponse response = new FormSubmissionResponse();
        response.setFormName(this.getFormName());
        response.setSuccess(true);
        return response;
    }

    protected String buildPdfSaveLocation(String ... subfolders) {
        return this.pdfStorageHelper.buildAndPrepare(this.customProperties.getPdfFiles(), subfolders);
    }

    protected String getDepartmentEmail(String departmentKey, String formName) {
        String email = (String)this.customProperties.getDepartmentEmails().get(departmentKey);
        if (email == null || email.isBlank()) {
            throw new IllegalStateException(String.format("Missing cbm.departmentEmails.%s configuration for %s", departmentKey, formName));
        }
        return email;
    }

    protected abstract void validateFormData(T var1);

    protected abstract FormContext buildFormContext(T var1);

    protected abstract Document generateHtmlDocument(FormContext var1, T var2) throws IOException;

    protected abstract String getFormName();

    protected abstract Long getEntityId(T var1);

    protected abstract void setSubmittedDate(T var1);
}

