/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.VO.SessionInfoVO;
import com.cbmportal.portal.exceptions.ValidationException;
import com.cbmportal.portal.services.SessionManagementService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/sessions"})
public class SessionManagementController {
    private static final Logger log = LoggerFactory.getLogger(SessionManagementController.class);
    private final SessionManagementService sessionManagementService;

    public SessionManagementController(SessionManagementService sessionManagementService) {
        this.sessionManagementService = sessionManagementService;
    }

    @GetMapping(value={"/my-sessions"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<SessionInfoVO>> getMySessions(Authentication authentication) {
        String username = this.extractUsername(authentication);
        log.info("Fetching sessions for user: {}", (Object)username);
        List sessions = this.sessionManagementService.getUserSessions(username);
        log.debug("Found {} active sessions for user: {}", (Object)sessions.size(), (Object)username);
        return ResponseEntity.ok((Object)sessions);
    }

    @GetMapping(value={"/count"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<Map<String, Integer>> getSessionCount(Authentication authentication) {
        String username = this.extractUsername(authentication);
        log.debug("Getting session count for user: {}", (Object)username);
        int count = this.sessionManagementService.getActiveSessionCount(username);
        log.debug("User {} has {} active sessions", (Object)username, (Object)count);
        return ResponseEntity.ok(Map.of("count", count));
    }

    @DeleteMapping(value={"/{sessionId}"})
    @PreAuthorize(value="hasAnyAuthority('Admin','Office')")
    public ResponseEntity<Map<String, String>> revokeSession(@PathVariable Long sessionId, Authentication authentication) {
        String username = this.extractUsername(authentication);
        log.info("Admin {} requesting to revoke session ID: {}", (Object)username, (Object)sessionId);
        this.sessionManagementService.revokeAnySession(sessionId);
        log.info("Session {} revoked successfully by admin {}", (Object)sessionId, (Object)username);
        return ResponseEntity.ok(Map.of("message", "Session revoked successfully"));
    }

    @PostMapping(value={"/revoke-others"})
    @PreAuthorize(value="hasAnyAuthority('Admin','Office')")
    public ResponseEntity<Map<String, String>> revokeOtherSessions(@RequestBody Map<String, Long> request, Authentication authentication) {
        String username = this.extractUsername(authentication);
        Long currentTokenId = request.get("currentTokenId");
        if (currentTokenId == null) {
            log.warn("Revoke others request missing currentTokenId by admin: {}", (Object)username);
            throw new ValidationException("Current token ID is required");
        }
        log.info("Admin {} requesting to revoke all other sessions for the owning user (keeping token ID: {})", (Object)username, (Object)currentTokenId);
        this.sessionManagementService.revokeAllUserSessionsExceptCurrent(username, currentTokenId);
        log.info("All other sessions revoked by admin: {}", (Object)username);
        return ResponseEntity.ok(Map.of("message", "All other sessions have been logged out"));
    }

    @GetMapping(value={"/all"})
    @PreAuthorize(value="hasAnyAuthority('Admin','Office')")
    public ResponseEntity<List<SessionInfoVO>> getAllSessions() {
        log.info("Admin request to fetch all active sessions");
        List sessions = this.sessionManagementService.getAllActiveSessions();
        log.info("Retrieved {} active sessions across all users", (Object)sessions.size());
        return ResponseEntity.ok((Object)sessions);
    }

    @GetMapping(value={"/user/{username}"})
    @PreAuthorize(value="hasAnyAuthority('Admin','Office')")
    public ResponseEntity<List<SessionInfoVO>> getUserSessions(@PathVariable String username) {
        log.info("Admin request to fetch sessions for user: {}", (Object)username);
        List sessions = this.sessionManagementService.getUserSessions(username);
        log.debug("Found {} active sessions for user: {}", (Object)sessions.size(), (Object)username);
        return ResponseEntity.ok((Object)sessions);
    }

    @PostMapping(value={"/cleanup"})
    @PreAuthorize(value="hasAnyAuthority('Admin','Office')")
    public ResponseEntity<Map<String, Object>> cleanupExpiredTokens() {
        log.info("Admin request to manually cleanup expired tokens");
        int deletedCount = this.sessionManagementService.cleanupExpiredTokens();
        log.info("Cleanup complete. Deleted {} expired tokens", (Object)deletedCount);
        return ResponseEntity.ok(Map.of("message", "Cleanup completed successfully", "deletedCount", deletedCount));
    }

    private String extractUsername(Authentication authentication) {
        Object object;
        if (authentication != null && (object = authentication.getPrincipal()) instanceof Jwt) {
            Jwt jwt = (Jwt)object;
            return jwt.getSubject();
        }
        throw new IllegalStateException("Unable to extract username from authentication");
    }
}

