/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.configurations;

import com.cbmportal.portal.domains.VO.ErrorResponse;
import com.cbmportal.portal.exceptions.AuthenticationFailedException;
import com.cbmportal.portal.exceptions.DatabaseOperationException;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.exceptions.ResourceNotFoundException;
import com.cbmportal.portal.exceptions.ValidationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    private String getCorrelationId(HttpServletRequest request) {
        if (request == null) {
            return UUID.randomUUID().toString();
        }
        Object cid = request.getAttribute("CORRELATION_ID");
        return cid != null ? cid.toString() : UUID.randomUUID().toString();
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<ErrorResponse> handleResourceNotFoundException(ResourceNotFoundException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.warn("[cid:{}] Resource not found - Path: {}, Message: {}", new Object[]{correlationId, request.getRequestURI(), ex.getMessage()});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.NOT_FOUND, ex.getMessage(), request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<ErrorResponse> handleValidationException(ValidationException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.warn("[cid:{}] Validation error - Path: {}, Message: {}", new Object[]{correlationId, request.getRequestURI(), ex.getMessage()});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST, ex.getMessage(), request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AuthenticationFailedException.class})
    public ResponseEntity<ErrorResponse> handleAuthenticationException(AuthenticationFailedException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.warn("[cid:{}] Authentication failed - Path: {}, Message: {}", new Object[]{correlationId, request.getRequestURI(), ex.getMessage()});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.UNAUTHORIZED, "Authentication failed: " + ex.getMessage(), request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={UsernameNotFoundException.class})
    public ResponseEntity<ErrorResponse> handleUsernameNotFoundException(UsernameNotFoundException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.warn("[cid:{}] Username not found - Path: {}", (Object)correlationId, (Object)request.getRequestURI());
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.UNAUTHORIZED, "Invalid username or password", request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={FormProcessingException.class})
    public ResponseEntity<ErrorResponse> handleFormProcessingException(FormProcessingException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.error("[cid:{}] Form processing error - Path: {}, Message: {}", new Object[]{correlationId, request.getRequestURI(), ex.getMessage(), ex});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR, "Error processing form: " + ex.getMessage(), request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={DatabaseOperationException.class})
    public ResponseEntity<ErrorResponse> handleDatabaseOperationException(DatabaseOperationException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.error("[cid:{}] Database operation error - Path: {}, Message: {}", new Object[]{correlationId, request.getRequestURI(), ex.getMessage(), ex});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR, "Database operation failed: " + ex.getMessage(), request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={DataAccessException.class})
    public ResponseEntity<ErrorResponse> handleDataAccessException(DataAccessException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.error("[cid:{}] Data access error - Path: {}", new Object[]{correlationId, request.getRequestURI(), ex});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR, "Database error occurred", request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={IOException.class})
    public ResponseEntity<ErrorResponse> handleIOException(IOException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.error("[cid:{}] IO error - Path: {}, Message: {}", new Object[]{correlationId, request.getRequestURI(), ex.getMessage(), ex});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR, "File operation error: " + ex.getMessage(), request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={NullPointerException.class})
    public ResponseEntity<ErrorResponse> handleNullPointerException(NullPointerException ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.error("[cid:{}] Null pointer exception - Path: {}", new Object[]{correlationId, request.getRequestURI(), ex});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR, "An unexpected error occurred. Please contact support.", request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        JsonMappingException mappingException;
        HttpServletRequest servletRequest = (HttpServletRequest)request.resolveReference("request");
        String requestPath = servletRequest != null ? servletRequest.getRequestURI() : "unknown";
        String correlationId = this.getCorrelationId(servletRequest);
        String pathInfo = null;
        Throwable cause = ex.getCause();
        if (cause instanceof JsonMappingException && (mappingException = (JsonMappingException)cause).getPath() != null && !mappingException.getPath().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (JsonMappingException.Reference ref : mappingException.getPath()) {
                if (ref.getFieldName() != null) {
                    if (!sb.isEmpty()) {
                        sb.append(".");
                    }
                    sb.append(ref.getFieldName());
                    continue;
                }
                if (ref.getIndex() < 0) continue;
                sb.append("[").append(ref.getIndex()).append("]");
            }
            pathInfo = sb.toString();
        }
        Object userMessage = pathInfo != null && !pathInfo.isBlank() ? "Invalid request body: error deserializing field '" + pathInfo + "'." : "Invalid request body: unable to read JSON payload.";
        log.warn("[cid:{}] JSON parse error - Path: {}, FieldPath: {}, Message: {}", new Object[]{correlationId, requestPath, pathInfo, ex.getMessage()});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST, (String)userMessage, requestPath);
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponse> handleGlobalException(Exception ex, HttpServletRequest request) {
        String correlationId = this.getCorrelationId(request);
        log.error("[cid:{}] Unexpected error - Path: {}, Type: {}, Message: {}", new Object[]{correlationId, request.getRequestURI(), ex.getClass().getSimpleName(), ex.getMessage(), ex});
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR, "An unexpected error occurred: " + ex.getMessage(), request.getRequestURI());
        errorResponse.setCorrelationId(correlationId);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

